from RGameLib import *
from Bullet import *

class Gun(RG_Script):

    ROFTimer = RG_TimePoint()
    reloadTimer = RG_TimePoint()
    startedReload = False
    
    rateOfFire = 2
    reloadSpeed = 1
    magSize = 3
    ammo = 3
    bulletSpeed = 10
    
    aimAssist = 2
    
    def PhysicsTick(self, deltaTime):
        
        if(self.ammo == 0 and not self.startedReload):
            self.startedReload = True
            self.reloadTimer.Now()
            
        if(self.reloadSpeed > self.reloadTimer.Diff() and self.startedReload):
            return
        
        if(self.startedReload):
            self.ammo = self.magSize
            self.startedReload = False
        
    
    def Shoot(self, targetPosition):
        
        if(self.reloadSpeed > self.reloadTimer.Diff() and self.startedReload):
            return
        
        if self.ammo == 0: 
            return
        if self.ROFTimer.Diff() < (1/self.rateOfFire): return
        
        self.ammo -= 1
        self.Pos = RG_Position2D(self.Position.X, self.Position.Y)
        self.Vel = self.Position.VectorTo(targetPosition).ToVelocity()
        self.Vel.SetSpeed(self.bulletSpeed)
        self.MainScript.Bullets.append(
            Bullet(self.MainScript,
                    position = self.Pos,
                    velocity = self.Vel,
                    appearance = RG_App_Circle(self.MainWindow.Screen, radius = 2, color = "grey")))
        
        self.ROFTimer.Now()

class Revolver(Gun):
    
    def Start(self):
        self.reloadSpeed = 2
        self.rateOfFire = 3
        
class Shotgun(Gun):
    
    def Start(self):
        self.reloadSpeed = 4
        self.rateOfFire = 0.5
        
    def Shoot(self, targetPosition):
        if(self.reloadSpeed > self.reloadTimer.Diff() and self.startedReload):
            return
        
        if self.ammo == 0: 
            return
        if self.ROFTimer.Diff() < (1/self.rateOfFire): return
        
        self.ammo -= 1
        self.Pos = RG_Position2D(self.Position.X, self.Position.Y)
        self.Vel = self.Position.VectorTo(targetPosition).ToVelocity()
        self.Vel.SetSpeed(self.bulletSpeed)
        for i in range(5):
            randVel = RG_Velocity2D(RandomFloat()*6, RandomFloat()*6)
            self.Vel += randVel
            self.MainScript.Bullets.append(
                Bullet(self.MainScript,
                        position = self.Pos,
                        velocity = self.Vel,
                        appearance = RG_App_Circle(self.MainWindow.Screen, radius = 1, color = "grey")))
            self.MainScript.Bullets[-1].aim = 1
        
        self.ROFTimer.Now()