﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinearAlgebraCsharpe
{
    public class OzMatrix
    {
        public decimal[,] Elements;
        public OzMatrix(decimal[,] elements)
        {
            Elements = elements;
        }
        public OzMatrix()
        {
            Elements = new decimal[1, 1] { { 0M } };
        }

        public static OzVector operator *(OzMatrix m, OzVector v)
        {
            decimal[] res = (decimal[])v.Rn.Clone();
            for(int x = 0; x < res.Length; x++)
            {
                decimal total = 0;
                for (int y = 0; y < res.Length; y++)
                {
                    total += res[y] * m.Elements[x, y];
                }
                res[x] = total;
            }
            return new OzVector(res);
        }
    }
}
