﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinearAlgebraCsharpe
{
    public class OzVector
    {
        public decimal[] Rn;
        decimal _length;
        decimal[] _oldRn;

        public OzVector(decimal[] rn)
        {
            Rn = rn;
            _length = 0;
            _oldRn = new decimal[rn.Length];
            for (int x = 0; x < _oldRn.Length; x++)
            {
                _oldRn[x] = 0;
            }
        }



        //operators
        // +
        public static OzVector operator +(OzVector left, OzVector right)
        {
            var result = new decimal[right.Rn.Length];
            for (int x = 0; x < right.Rn.Length; x++)
            {
                result[x] = right.Rn[x];
            }
            for (int x = 0; x < left.Rn.Length; x++)
            {
                result[x] += left.Rn[x];
            }
            return new OzVector(result);
        }
        // -
        public static OzVector operator -(OzVector left, OzVector right)
        {
            var result = new decimal[right.Rn.Length];
            for (int x = 0; x < right.Rn.Length; x++)
            {
                result[x] = right.Rn[x];
            }
            for (int x = 0; x < left.Rn.Length; x++)
            {
                result[x] -= left.Rn[x];
            }
            return new OzVector(result);
        }
        // *
        public static OzVector operator *(OzVector left, decimal k)
        {
            var result = new decimal[left.Rn.Length];
            for (int x = 0; x < left.Rn.Length; x++)
            {
                result[x] = left.Rn[x];
            }
            for (int x = 0; x < left.Rn.Length; x++)
            {
                result[x] *= k;
            }
            return new OzVector(result);
        }

        public static OzVector operator *(decimal k, OzVector right)
        {
            return right * k;
        }
        // /
        public static OzVector operator /(OzVector left, decimal k)
        {
            var result = new decimal[left.Rn.Length];
            for (int x = 0; x < left.Rn.Length; x++)
            {
                result[x] = left.Rn[x];
            }
            for (int x = 0; x < left.Rn.Length; x++)
            {
                result[x] /= k;
            }
            return new OzVector(result);
        }

        //functions
        /// <summary>
        /// This Function gets the length of said vector. It saves time by returning the previus calculations value if no change has been
        /// detected. Despite this the GetlengthSq variant is recommended above when posible
        /// </summary>
        /// <returns>The length of said vector</returns>
        public decimal Getlength()
        {
            if (!checkForChange()) return _length;
            _length = (decimal)Math.Sqrt((double)GetlengthSq());
            return _length;
        }


        /// <summary>
        /// This is function gets the length but doesn't do the sqrt-ing therefore faster.
        /// This is recommended to be use for checks over the normal GetLength.
        /// </summary>
        /// <returns>The length squared</returns>
        public decimal GetlengthSq()
        {
            decimal result = 0;
            for(int x = 0; x < Rn.Length; x++)
            {
                result += Rn[x] * Rn[x];
            }
            return result;
        }


        /// <summary>
        /// Sets the length of said vector. The normalisation function is recomended instead of setlen 1.
        /// </summary>
        /// <param name="len">The length the vector will be set to</param>
        public void SetLength(decimal len)
        {
            if (len == 0 || Getlength() == 0)
            {
                for (int x = 0; x < Rn.Length; x++)
                {
                    Rn[x] = 0;
                }
            }
            Rn = (this / Getlength() * len).Rn;
        }


        /// <summary>
        /// sets the length to 1 but faster that set length
        /// </summary>
        public void Normalise()
        {
            Rn = (this / Getlength()).Rn;
        }

        bool checkForChange()
        {
            var result = Rn != _oldRn;
            _oldRn = Rn;
            return result;
        }
    }
}
