﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using LinearAlgebraCsharpe;

namespace TriangleFractle
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            CompositionTarget.Rendering += render;
            p1 = new OzPoint2D(0,400);
            p2 = new OzPoint2D(200,62);
            p3 = new OzPoint2D(400,400);
            old = new OzPoint2D(400, 400);
            r = new Random();
        }
        OzPoint2D p1;
        OzPoint2D p2;
        OzPoint2D p3;
        OzPoint2D old;
        Random r;
        Color color;
        int _speed = 0;
        double size = 0;
        void render(object o, EventArgs args)
        {
            for(int x = 0; x < _speed; x++)
            {
                OzVector dist = (old - choose());
                dist = dist / 2;
                old.X += dist.Rn[0];
                old.Y += dist.Rn[1];
                var pix = new Ellipse() { Width = size, Height = size, Fill = new SolidColorBrush(color) };
                paper.Children.Add(pix);
                Canvas.SetLeft(pix, (double)old.X);
                Canvas.SetTop(pix, (double)old.Y);
            }
        }

        OzPoint2D choose()
        {
            var num = r.Next(0, 3);
            if (0 == num) return p1;
            else if (1 == num) return p2;
            else return p3;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            if (sp.Text == "") sp.Text = "0";
            _speed = int.Parse(sp.Text);
            if (sz.Text == "") sz.Text = "0";
            sz.Text = sz.Text.Replace('.', ',');
            size = double.Parse(sz.Text);
            if (cl.Text == "") cl.Text = "Black";
            color = (Color)ColorConverter.ConvertFromString(cl.Text);
            paper.Children.Clear();

        }
    }
}
