﻿using LinearAlgebraCsharpe;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Engine3D
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        OzMesh cube;
        OzVector3D camera;
        decimal zoom = 1;
        bool First = true;
        OzMatrix rotator;
        public MainWindow()
        {
            InitializeComponent();
            
        }
        OzVector3D rotate(OzVector v, double angle)
        {
            angle = angle * Math.PI / 180;
            rotator = new OzMatrix(new decimal[,]
            {
                {(decimal)Math.Cos(angle), 0, -(decimal)Math.Sin(angle)},
                {0, 1, 0},
                {-(decimal)Math.Sin(angle),0,(decimal)Math.Cos(angle)}
            });
            var res = rotator*v;
            return new OzVector3D(res.Rn);
        }
        void render(object o, EventArgs e)
        {
            if (cube.Init((int)Paper.ActualWidth, (int)Paper.ActualHeight, zoom, camera))
            {
                Paper.Children.Clear();
                for (int x = 0; x < cube._polygons.Length; x++)
                {
                    Paper.Children.Add(cube._polygons[x]._gfxPolygon._gfxPolygon);
                }
            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            cube = getcube();
            CompositionTarget.Rendering += render;
        }
        OzMesh getcube()
        {
            var zoom = 1;
            camera = new OzVector3D(0, 0, 0.1M);

            OzPloygon3D[] cubeSides = new OzPloygon3D[6]
            {
                //south
                new OzPloygon3D(new OzPoint3D[4]
                {
                    new OzPoint3D(-0.1M, -0.1M, 0),new OzPoint3D( -0.1M,0.1M,0),new OzPoint3D(0.1M,0.1M,0),new OzPoint3D(0.1M, -0.1M,0)
                },new OzVector3D(0, 0, -0.1M),(int)Paper.ActualHeight,(int)Paper.ActualHeight,zoom,camera),
                //top
                new OzPloygon3D(new OzPoint3D[4]
                {
                    new OzPoint3D(-0.1M, 0, -0.1M),new OzPoint3D(-0.1M, 0,0.1M),new OzPoint3D(0.1M, 0,0.1M),new OzPoint3D(0.1M, 0,-0.1M)

                },new OzVector3D(0, 0.1M, 0),(int)Paper.ActualHeight,(int)Paper.ActualHeight,zoom,camera),
                //east
                new OzPloygon3D(new OzPoint3D[4]
                {
                    new OzPoint3D(0, -0.1M, -0.1M),new OzPoint3D( 0,0.1M,-0.1M),new OzPoint3D( 0,0.1M,0.1M),new OzPoint3D( 0, -0.1M,0.1M)
                },new OzVector3D(0.1M, 0, 0),(int)Paper.ActualHeight,(int)Paper.ActualHeight,zoom,camera),
                //North
                new OzPloygon3D(new OzPoint3D[4]
                {
                    new OzPoint3D(-0.1M, -0.1M, 0),new OzPoint3D(0.1M, -0.1M,0),new OzPoint3D(0.1M,0.1M,0),new OzPoint3D( -0.1M,0.1M,0)
                },new OzVector3D(0, 0, 0.1M),(int)Paper.ActualHeight,(int)Paper.ActualHeight,zoom,camera),
                //bottom
                new OzPloygon3D(new OzPoint3D[4]
                {
                    new OzPoint3D(-0.1M, 0, -0.1M),new OzPoint3D(0.1M, 0,-0.1M),new OzPoint3D(0.1M, 0,0.1M),new OzPoint3D( -0.1M, 0,0.1M)

                },new OzVector3D(0, -0.1M, 0),(int)Paper.ActualHeight,(int)Paper.ActualHeight,zoom,camera),

                //west
                new OzPloygon3D(new OzPoint3D[4]
                {
                    new OzPoint3D(0, -0.1M, -0.1M),new OzPoint3D( 0, -0.1M,0.1M),new OzPoint3D( 0,0.1M,0.1M),new OzPoint3D( 0,0.1M,-0.1M)
                },new OzVector3D(-0.1M, 0, 0),(int)Paper.ActualHeight,(int)Paper.ActualHeight,zoom,camera)
            };

            return new OzMesh(cubeSides, new OzVector3D(0, 0, 1M));
        }
        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.R)
            {
                cube = getcube();
            }
            if (e.Key == Key.Space)
            {
                var total = cube.Position + new OzVector3D(0, 0.01M, 0);
                cube.Position = new OzVector3D(total.Rn);
            }
            if (e.Key == Key.LeftShift)
            {
                var total = cube.Position + new OzVector3D(0, -0.01M, 0);
                cube.Position = new OzVector3D(total.Rn);
            }
            if (e.Key == Key.D)
            {
                var total = cube.Position + new OzVector3D(0.01M, 0, 0);
                cube.Position = new OzVector3D(total.Rn);
                //for (int x = 0; x < cube._polygons.Length; x++)
                //{
                //    for (int y = 0; y < cube._polygons[x]._points.Length; y++)
                //    {
                //        cube._polygons[x]._points[y] = rotate((OzVector)cube._polygons[x]._points[y],10);
                //    }
                //}
            }
            if (e.Key == Key.A)
            {
                var total = cube.Position + new OzVector3D(-0.01M, 0, 0);
                cube.Position = new OzVector3D(total.Rn);
            }
            if (e.Key == Key.W)
            {
                var total = cube.Position + new OzVector3D(0, 0, 0.01M);
                cube.Position = new OzVector3D(total.Rn);
            }
            if (e.Key == Key.S)
            {
                var total = cube.Position + new OzVector3D(0, 0, -0.01M);
                cube.Position = new OzVector3D(total.Rn);
            }
            if (cube.Position.Rn[2] < 0.2M)
            {
                cube.Position.Rn[2] = 0.2M;
            }
        }

        private void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            Paper.Width = e.NewSize.Width;
            Paper.Height = e.NewSize.Height;
            if (First) { First = false; return; };
            var total = cube.Position + new OzVector3D(0, 0.0000001M, 0);
            cube.Position = new OzVector3D(total.Rn);
            cube.Init((int)Paper.ActualWidth, (int)Paper.ActualHeight, zoom, camera);
        }


        private void Window_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            zoom += ((decimal)e.Delta) / -10000;
            if (zoom < 0) zoom = 0;
            if (zoom > (decimal)Math.PI) zoom = (decimal)Math.PI ;
        }
    }
}
