﻿using LinearAlgebraCsharpe;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Engine3D
{
    public class OzMesh
    {
        public OzPloygon3D[] _polygons;
        public OzVector3D Position;
        OzVector3D _oldPostion;
        decimal _oldzoom;

        public OzMesh(OzPloygon3D[] polygons, OzVector3D position)
        {
            _polygons = polygons;
            Position = position;
            _oldPostion = null;
        }

        public bool Init(int width, int height, decimal zoom, OzVector3D camera)
        {
            if (!(_oldPostion != Position || _oldzoom != zoom) ) return false;
            if (_oldPostion == null) _oldPostion = new OzVector3D(0, 0, 0);
            _oldzoom = zoom;
            var deltaPosition = _oldPostion - Position;
            _oldPostion = Position;
            for(int x = 0; x < _polygons.Length; x++)
            {
                var total = _polygons[x].Position + deltaPosition;
                _polygons[x].Position = new OzVector3D(total.Rn);
                _polygons[x].Init(height, width, zoom,camera);
            }
            return true;
        }
    }
}
