﻿using LinearAlgebraCsharpe;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;

namespace Engine3D
{
    public class OzPloygon3D
    {
        public OzPloygon3D(OzPoint3D[] points, OzVector3D position, int height, int width, int zoom, OzVector3D camera)
        {
            _points = points;
            _gfxPolygon = new OzPolygon2D(new OzPoint2D[_points.Length]);
            Position = position;
            Init( height, width, zoom,camera);
        }
        public OzPoint3D[] _points;
        public OzVector3D Position;
        public OzPolygon2D _gfxPolygon;

        public void Init(int height, int width, decimal zoom, OzVector3D camera)
        {
            if (Position.Rn[2] < camera.Rn[2]) return;
            var line1 = _points[0] - _points[1];
            var line2 = _points[0] - _points[_points.Length - 1];
            var normal = ((OzVector3D)line1).GetNormal((OzVector3D)line2);
            if (normal.Rn[2] > 0)
            {
                _gfxPolygon._gfxPolygon.Fill = null;
                _gfxPolygon._gfxPolygon.Stroke = null;
                return;
            }
            var vecPointToCam = camera - (_points[0] + Position);
            if (vecPointToCam.GetlengthSq() >= (vecPointToCam - normal).GetlengthSq())
            {
                _gfxPolygon._gfxPolygon.Fill = null;
                _gfxPolygon._gfxPolygon.Stroke = null;
                return;
            }
            if (normal.DotProduct(camera) > 0)
            {
                _gfxPolygon._gfxPolygon.Fill = null;
                _gfxPolygon._gfxPolygon.Stroke = null;
                return;
            }
            if(_gfxPolygon._gfxPolygon.Fill == null)
            {
                _gfxPolygon._gfxPolygon.Fill = new SolidColorBrush(Colors.Red);
                _gfxPolygon._gfxPolygon.Stroke = new SolidColorBrush(Colors.Black);
            }
            var points2D = new OzPoint2D[_points.Length];
            for(int x = 0; x < _points.Length; x++)
            {
                points2D[x] = (_points[x]+Position).Projection2D(height, width, zoom,0.01M);
            }
            for (int x = 0; x < _points.Length; x++)
            {
                points2D[x].Y = height-points2D[x].Y;
            }
            _gfxPolygon.Points = points2D;
            _gfxPolygon.Init();
        }
    }
}
