﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace LinearAlgebraCsharpe
{
    public struct OzPoint2D
	{
		public decimal X;
		public decimal Y;

		// constructors
		public OzPoint2D(decimal x, decimal y)
		{
			X = x;
			Y = y;
		}

		//operators
		// +
		public static OzPoint2D operator +(OzPoint2D left, OzVector2D right)
		{
			return new OzPoint2D(left.X + right.Rn[0], left.Y + right.Rn[1]);
		}
		public static OzPoint2D operator +(OzVector2D right, OzPoint2D left)
		{
			return left + right;
		}
		// -
		public static OzVector2D operator -(OzPoint2D left, OzPoint2D right)
		{
			return new OzVector2D(right.X - left.X, right.Y - left.Y);
		}

		//casts
		public static  implicit operator OzVector2D(OzPoint2D point)
		{
			return new OzVector2D(point.X, point.Y);
		}

		public static implicit operator OzPoint2D(OzVector2D vector)
		{
			return new OzPoint2D(vector.Rn[0], vector.Rn[1]);
		}

		public static implicit operator Point(OzPoint2D point)
		{
			return new Point((double)point.X, (double)point.Y);
		}

	};
}
