﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace LinearAlgebraCsharpe
{
    public struct OzPoint3D
	{
		public decimal X;
		public decimal Y;
		public decimal Z;

		// constructors
		public OzPoint3D(decimal x, decimal y, decimal z)
		{
			X = x;
			Y = y;
			Z = z;
		}

		//operators
		// +
		public static OzPoint3D operator +(OzPoint3D left, OzVector right)
		{
			return new OzPoint3D(left.X + right.Rn[0], left.Y + right.Rn[1], left.Z + right.Rn[2]);
		}
		public static OzPoint3D operator +(OzVector right, OzPoint3D left)
		{
			return left + right;
		}
		// -
		public static OzVector operator -(OzPoint3D left, OzPoint3D right)
		{
			return new OzVector3D(right.X - left.X, right.Y - left.Y, right.Z - left.Z);
		}

		//casts
		public static  explicit operator OzVector(OzPoint3D point)
		{
			return new OzVector(new decimal[] { point.X, point.Y, point.Z });
		}

		public static implicit operator OzPoint3D(OzVector vector)
		{
			return new OzPoint3D(vector.Rn[0], vector.Rn[1],vector.Rn[2]);
		}


		public OzPoint2D Projection2D(decimal height, decimal width, decimal zoom, decimal Znear)
		{
			var a = width / height;
			decimal fieldOfVeiw;
			if (Z != 0)
			{
				Z += Znear;
				fieldOfVeiw = (decimal)Math.Tan((double)(zoom / 2)) / Z * 1.83M;
				Z -= Znear;
			}
			else
				fieldOfVeiw = 0;
			var screenRelativeProj = new OzPoint2D((X * fieldOfVeiw /a), (Y * fieldOfVeiw));
			screenRelativeProj.X = (screenRelativeProj.X + 1) * (width / 2);
			screenRelativeProj.Y = (screenRelativeProj.Y + 1) * (height / 2);
			return screenRelativeProj;
		}
	};
}
