﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinearAlgebraCsharpe
{
    public class OzVector3D: OzVector
	{

        public OzVector3D(decimal[] rn) : base(rn)
        {
            Rn = rn;
        }

        // constructors
        public OzVector3D(decimal x, decimal y, decimal z) : base(new decimal[] { x, y, z })
		{
        }
        OzVector getVec()
        {
            return new OzVector(Rn);
        }

        public OzPoint2D Projection2D(decimal height, decimal width, decimal zoom, decimal Znear)
        {
            var a = width / height;
            decimal fieldOfVeiw;
            if (Rn[2] != 0)
            {
                Rn[2] += Znear;
                fieldOfVeiw = (decimal)Math.Tan((double)(zoom / 2)) / Rn[2] * 1.83M;
                Rn[2] -= Znear;
            }
            else
                fieldOfVeiw = 0;
            var screenRelativeProj = new OzPoint2D((Rn[0] * fieldOfVeiw / a), (Rn[1] * fieldOfVeiw));
            screenRelativeProj.X = (screenRelativeProj.X + 1) * (width / 2);
            screenRelativeProj.Y = (screenRelativeProj.Y + 1) * (height / 2);
            return screenRelativeProj;
        }


        public OzVector3D GetNormal(OzVector3D other)
        {
            var result = new OzVector3D(
                Rn[1] * other.Rn[2] - other.Rn[1] * Rn[2],
                other.Rn[0] * Rn[2] - Rn[0] * other.Rn[2],
                other.Rn[1] * Rn[0] - Rn[1] * other.Rn[0]
                );
            result.SetLength(0.01M);
            return result;
        }


        public decimal DotProduct(OzVector3D other)
        {
            decimal result = 0;
            for(int x = 0; x< 3; x++)
            {
                result += Rn[x]*other.Rn[x];
            }
            return result;
        }
    }
}
