﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinearAlgebraCsharpe
{
    public static class OzVectorNumberOperations
    {
        /// <summary>
        /// This is function gets the length
        /// </summary>
        /// <param name="number">The number we treat as a vector</param>
        /// <returns>The length</returns>
        public static decimal Getlength(decimal number)
        {
            return Math.Abs(number);
        }

        /// <summary>
        /// Sets the length of said vector. The normalisation function is recomended instead of setlen 1.
        /// </summary>
        /// <param name="len">The length the vector will be set to</param>
        /// <param name="number">The number we treat as a vector</param>
        /// <returns>Set number.</returns>
        public static decimal SetLength(decimal len, decimal number)
        {
             return (number / Getlength(number) * len);
        }

        /// <summary>
        /// Sets the length to 1 but faster that set length.
        /// </summary>
        /// <param name="number">The number we treat as a vector</param>
        /// <returns>Set number.</returns>
        public static decimal Normalise(decimal number)
        {
            return number / Getlength(number);
        }

        /// <summary>
        /// This normalises a list of numbers so thier total is 1
        /// </summary>
        /// <param name="number">List of numbers to be normalised.</param>
        /// <returns>Normalised list.</returns>
        public static double[] NormaliseTotal(double[] number)
        {
            double len = 0;
            for (int x = 0; x < number.Length; x++)
            {
                len += number[x];
            }
            if(len == 1)return number;
            for (int x = 0; x < number.Length; x++)
            {
                number[x] /= len;
            }
            return number;
        }
    }
}
