using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Player : SpaceEntity
{
    public static Sprite PlayerSkin;
    public static PhysicsMaterial2D PlayerMaterial;
    public GameObject MainCamera;
    SpriteRenderer _renderer;
    public Player(string name) : base(name)
    {
        Instance.layer = LayerMask.NameToLayer("player");

        var myThruster = GetResource("ThrusterEffects");
        myThruster.transform.position = new Vector3(0, -0.5f, 0);
        myThruster.transform.Rotate(new Vector3(90, -90, 0));

        var myLight1 = GetResource("AstronautLight");
        var myLight2 = GetResource("AstronautLight");
        myLight1.transform.position = new Vector3(-0.3f, 0.4f, 0);
        myLight1.transform.Rotate(new Vector3(0, 0, 0));
        myLight2.transform.position = new Vector3(0.3f, 0.4f, 0);
        myLight2.transform.Rotate(new Vector3(0, 0, 0));

        MainCamera = new GameObject("MainCamera");
        MainCamera.transform.position = new Vector3(0,0,-10);
        var cam = MainCamera.AddComponent<Camera>();
        cam.backgroundColor = Color.black;
        cam.orthographic = true;
        cam.orthographicSize = 5;
        MainCamera.transform.parent = Instance.transform;
        _renderer = Instance.AddComponent<SpriteRenderer>();
        _renderer.sprite = PlayerSkin;
        Physics.Mass = 70;
        Physics.I = 6;
        InitPhysics();
        GameObject.Destroy(Collider);
        Collider = Instance.AddComponent<CircleCollider2D>();
        //Collider.sharedMaterial = PlayerMaterial;
        
    }

    protected override void GFXtick()
    {
        var moveSpeed = 40f;
        var turnSpeed = 0.001f;
        if (Input.GetKey(KeyCode.W) || Input.GetKey(KeyCode.UpArrow))
        {
            Physics.AddForce(Vector2.up * moveSpeed * Physics.Mass * Time.deltaTime);
        }
        if (Input.GetKey(KeyCode.S) || Input.GetKey(KeyCode.DownArrow))
        {
            Physics.AddForce(Vector2.down * moveSpeed * Physics.Mass * Time.deltaTime);
        }
        if (Input.GetKey(KeyCode.A) || Input.GetKey(KeyCode.UpArrow))
        {
            Physics.AddForce(Vector2.left * moveSpeed * Physics.Mass * Time.deltaTime);
        }
        if (Input.GetKey(KeyCode.D) || Input.GetKey(KeyCode.DownArrow))
        {
            Physics.AddForce(Vector2.right * moveSpeed * Physics.Mass * Time.deltaTime);
        }
        if (Input.GetKey(KeyCode.Q) || Input.GetKey(KeyCode.LeftArrow))
        {
            Physics.AddTorque(turnSpeed * Time.deltaTime);
        }
        if (Input.GetKey(KeyCode.E) || Input.GetKey(KeyCode.RightArrow))
        {
            Physics.AddTorque(-turnSpeed * Time.deltaTime);
        }
    }
    protected override void PhysicsTick(float dt)
    {
        if (Physics.Velocity.magnitude < 0.02)
        {
            Physics.Velocity = new Vector2();
        }
    }
}
