﻿using System.Collections.Generic;
using UnityEngine;
using System;

[RequireComponent(typeof(ParticleSystem))]
public class AttachGameObjectsToParticles : MonoBehaviour
{
    public GameObject m_Prefab;
    public float OuterRadius = 1;
    public float InnerRadius = 0.1f;
    public float Internsity = 0.1f;
    public bool ScaleWithSize = true;

    private ParticleSystem m_ParticleSystem;
    private List<GameObject> m_Instances = new List<GameObject>();
    private ParticleSystem.Particle[] m_Particles;

    // Start is called before the first frame update
    void Start()
    {
        m_ParticleSystem = GetComponent<ParticleSystem>();
        m_Particles = new ParticleSystem.Particle[m_ParticleSystem.main.maxParticles];
    }

    // Update is called once per frame
    void LateUpdate()
    {
        int count = m_ParticleSystem.GetParticles(m_Particles);

        while (m_Instances.Count < count)
            m_Instances.Add(Instantiate(m_Prefab, m_ParticleSystem.transform));

        bool worldSpace = (m_ParticleSystem.main.simulationSpace == ParticleSystemSimulationSpace.World);
        for (int i = 0; i < m_Instances.Count; i++)
        {
            if (ScaleWithSize)
                m_Instances[i].transform.localScale = new Vector3(m_Particles[i].startSize, m_Particles[i].startSize, m_Particles[i].startSize);
            var light = m_Instances[i].GetComponent<UnityEngine.Experimental.Rendering.Universal.Light2D>();
            light.pointLightInnerRadius = InnerRadius;
            light.pointLightOuterRadius = OuterRadius;
            light.intensity = Internsity;
            light.shadowIntensity = 1;
            light.color = m_Particles[i].GetCurrentColor(m_ParticleSystem);
            if (i < count)
            {
                if (worldSpace)
                    m_Instances[i].transform.position = m_Particles[i].position;
                else
                    m_Instances[i].transform.localPosition = m_Particles[i].position;
                m_Instances[i].SetActive(true);
            }
            else
            {
                m_Instances[i].SetActive(false);
            }
        }
    }
}
