using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class SpaceEntity
{
    public string Name;
    public GameObject Instance;
    public SpaceEntityPhysics Physics;
    public List<SpaceEntityComponent> Components;
    public Collider2D Collider;

    public GameObject GetResource(string name)
    {
        var resource =  GameObject.Find("ResourceIniter").transform.Find(name).gameObject;
        var clone = GameObject.Instantiate(resource);
        clone.transform.parent = Instance.transform;
        clone.transform.localPosition = new Vector3();
        clone.transform.localEulerAngles = new Vector3();
        clone.SetActive(true);
        return clone;
    }

    public SpaceEntity(string name)
    {
        Components = new List<SpaceEntityComponent>();
        Name = name;
        Instance = new GameObject(name);
        Physics = Instance.AddComponent<SpaceEntityPhysics>();
    }

    public void AddComp(SpaceEntityComponent comp)
    {
        if (Components.Contains(comp)) return;
        Components.Add(comp);
        Physics.ComponentEnities.Add(comp.Physics);
        comp.Physics.transform.parent = Instance.transform;
    }
    public void RmComp(SpaceEntityComponent comp)
    {
        if (!Components.Contains(comp)) return;
        Components.Remove(comp);
        Physics.ComponentEnities.Remove(comp.Physics);
        comp.Physics.transform.parent = null;
    }
    public void InitPhysics()
    {
        Collider = Instance.AddComponent<BoxCollider2D>();
        var rigidbody = Instance.AddComponent<Rigidbody2D>();
        Physics.Rigidbody = rigidbody;
        Physics.collide = Collieded;
        Physics.physicsTick = PhysicsTick;
        Physics.mouseDown = MouseDown;
        Physics.update = GFXtick;
        Physics.Init();
    }

    protected virtual void Collieded(Collision2D collision)
    {
        
    }

    protected virtual void PhysicsTick(float dt)
    {

    }

    protected virtual void MouseDown()
    {

    }

    protected virtual void GFXtick()
    {

    }
}
