using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SpaceEntityPhysics : MonoBehaviour
{
    public float Mass;
    public float I;
    public Vector2 CentreOfMass;
    public List<SECompPhysics> ComponentEnities;
    public Action<float> physicsTick;
    public Action<Collision2D> collide;
    public Action update;
    public Action mouseDown;
    public Rigidbody2D Rigidbody;

    public Vector2 Velocity
    {
        get { return Rigidbody.velocity; }
        set
        {
            Rigidbody.velocity = value;
        }
    }
    public Vector2 Position
    {
        get { return Rigidbody.position; }
        set
        {
            Rigidbody.position = value;
        }
    }

    public void Init()
    {
        Rigidbody.gravityScale = 0;
        Rigidbody.angularDrag = 0;
        UpdateCentreOfMass();
    }

    public void AddImpuls(Vector2 vec2)
    {
        Rigidbody.AddRelativeForce(vec2,ForceMode2D.Impulse);
    }

    public void AddForce(Vector2 vec2)
    {
        Rigidbody.AddRelativeForce(vec2, ForceMode2D.Force);
    }

    public void AddTorque(float torque)
    {
        Rigidbody.AddTorque(torque, ForceMode2D.Force);
    }

    public SpaceEntityPhysics()
    {
        ComponentEnities = new List<SECompPhysics>();
    }
    public void Start()
    {
        Mass = 1;
        I = 1;
    }

    public void FixedUpdate()
    {
        if (Rigidbody == null) return;
        Debug.DrawLine(Rigidbody.worldCenterOfMass + Vector2.down + Vector2.left, Rigidbody.worldCenterOfMass + Vector2.up + Vector2.right, Color.red);
        Debug.DrawLine(Rigidbody.worldCenterOfMass + Vector2.down + Vector2.right, Rigidbody.worldCenterOfMass + Vector2.up + Vector2.left, Color.red);
        Debug.DrawLine(Rigidbody.worldCenterOfMass, Rigidbody.worldCenterOfMass + Vector2.up * Rigidbody.inertia, Color.blue);
        if (physicsTick == null) return;
        physicsTick(Time.fixedDeltaTime);
    }

    public void Update()
    {
        if (update == null) return;
        update();
    }

    public void OnMouseDown()
    {
        if (mouseDown == null) return;
        mouseDown();
    }
    
    public void OnCollisionEnter2D(Collision2D collision)
    {
        //collision.transform
        if (collide == null) return;
        collide(collision);
    }
    public Vector2 ToVec2(Vector3 vector3)
    {
        return new Vector2(vector3.x, vector3.y);
    }


    public void UpdateCentreOfMass()
    {
        foreach (var comp in ComponentEnities)
        {
            comp.UpdateCentreOfMass();
        }
        var totalMass = 1f;
        CentreOfMass = new Vector2();
        foreach (var comp in ComponentEnities)
        {
            if (float.IsNaN(comp.CentreOfMass.x)) continue;
            var relativeCM = comp.CentreOfMass + comp.Position;
            var scaledCM = relativeCM * comp.TotalMass;
            totalMass += comp.TotalMass;

            CentreOfMass += scaledCM;
        }
        CentreOfMass /= totalMass;
        Mass = totalMass;
        I = 0;
        foreach (var comp in ComponentEnities)
        {
            if (float.IsNaN(comp.CentreOfMass.x)) continue;
            var relativeCM = comp.CentreOfMass + comp.Position;
            var scaledCM = relativeCM * comp.TotalMass;
            totalMass += comp.TotalMass;

            I += comp.GetMomentOfInertia(new Vector2(), CentreOfMass);
        }
        Debug.DrawLine(CentreOfMass + Vector2.down + Vector2.left, CentreOfMass + Vector2.up + Vector2.right, Color.red );
        Debug.DrawLine(CentreOfMass + Vector2.down + Vector2.right, CentreOfMass + Vector2.up + Vector2.left, Color.red );
        Debug.DrawLine(CentreOfMass, CentreOfMass + Vector2.up * I, Color.blue);
        if (Rigidbody == null) return;
        Rigidbody.inertia = I;
        Rigidbody.centerOfMass = CentreOfMass;
        Rigidbody.mass = Mass;
    }
}
