using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SECompPhysics : MonoBehaviour
{
    public Vector2 Position;
    public List<SECompPhysics> ComponentEnities;
    public SpaceEntityPhysics parent;
    public Action<float> physicsTick;
    public Action<Collision2D> collide;
    public Action update;
    public Action mouseDown;
    private float _mass;
    public Vector2 CentreOfMass;
    public float MassD;
    public float TotalMass;
    public float Mass
    {
        set
        {
            _mass = value;
            MassD = value;
            parent.UpdateCentreOfMass();
        }

        get
        {
            return _mass;
        }
    }
    public SECompPhysics()
    {
        ComponentEnities = new List<SECompPhysics>();
    }
    void Start()
    {
    }

    public void Init()
    {
        UpdateCentreOfMass();
    }

    void Update()
    {
        transform.localPosition = Position;
        Mass = MassD;
        if (update == null) return;
        update();
    }

    void FixedUpdate()
    {
        if (physicsTick == null) return;
        physicsTick(Time.fixedDeltaTime);
    }

    void OnMouseDown()
    {

        if (mouseDown == null) return;
        mouseDown();
    }
    private void OnCollisionEnter2D(Collision2D collision)
    {

        if (collide == null) return;
        collide(collision);
    }

    public void UpdateCentreOfMass()
    {
        foreach (var comp in ComponentEnities)
        {
            comp.UpdateCentreOfMass();
        }
        var totalMass = Mass;
        CentreOfMass = new Vector2();
        foreach (var comp in ComponentEnities)
        {
            if (float.IsNaN(comp.CentreOfMass.x)) continue;
            var relativeCM = comp.CentreOfMass + comp.Position;
            var scaledCM = relativeCM * comp.TotalMass;
            totalMass += comp.TotalMass;
            CentreOfMass += scaledCM;
        }
        TotalMass = totalMass;
        CentreOfMass /= totalMass;
    }

    public float GetMomentOfInertia(Vector2 relPos, Vector2 centreMass)
    {
        var I = 0f;
        foreach(var comp in ComponentEnities)
        {
            I += comp.GetMomentOfInertia(relPos+comp.Position, centreMass);
        }
        var dist = (relPos + CentreOfMass - centreMass).magnitude;
        return I + (Mass * dist * dist);
    }
}
