using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class SpaceEntityComponent
{
    public string Name;
    public SpaceEntity Parent;
    public GameObject Instance;
    public SECompPhysics Physics;
    public List<SpaceEntityComponent> Components;
    public Collider2D Collider;
    public bool Exists
    {
        get
        {
            return !Collider.isTrigger;
        }
        set { Collider.isTrigger = !value; }
    }

    public SpaceEntityComponent(string name, SpaceEntity parent)
    {
        Components = new List<SpaceEntityComponent>();
        Name = name;
        Instance = new GameObject(name);
        Physics = Instance.AddComponent<SECompPhysics>();
        Parent = parent;
        Physics.parent = parent.Physics;
    }

    public void InitPhysics()
    {
        Collider = (Collider2D)Instance.AddComponent<BoxCollider2D>();
        Collider.isTrigger = true;
        var rigidbody = Instance.AddComponent<Rigidbody2D>();
        rigidbody.isKinematic = true;
        rigidbody.useFullKinematicContacts = true;
        Physics.collide = Collieded;
        Physics.physicsTick = PhysicsTick;
        Physics.mouseDown = MouseDown;
        Physics.update = GFXtick;
        Physics.Init();
    }

    protected virtual void Collieded(Collision2D collision)
    {

    }

    protected virtual void PhysicsTick(float dt)
    {

    }

    protected virtual void MouseDown()
    {

    }

    protected virtual void GFXtick()
    {

    }

    public void AddComp(SpaceEntityComponent comp)
    {
        if (Components.Contains(comp)) return;
        Components.Add(comp);
        Physics.ComponentEnities.Add(comp.Physics);
        comp.Physics.transform.parent = Instance.transform;
    }

    public void RmComp(SpaceEntityComponent comp)
    {
        if (!Components.Contains(comp)) return;
        Components.Remove(comp);
        Physics.ComponentEnities.Remove(comp.Physics);
        comp.Physics.transform.parent = null;
    }

}
