using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SpaceShip : SpaceEntity
{
    public List<Tile> Tiles;
    public SpaceShip(string name) : base(name)
    {
        InitPhysics();
        Collider.enabled = false;
        Tiles = new List<Tile>();
        var baseTile = AddTile(new Vector2(0,0));
        baseTile.AddFloor();
        baseTile = AddTile(new Vector2(0, 1));
        baseTile.AddFloor();
        baseTile.AddWall(WallOrientation.left);
        baseTile.AddWall(WallOrientation.up);
        baseTile.AddWall(WallOrientation.crossRight);
        baseTile = AddTile(new Vector2(1, 0));
        baseTile.AddFloor();
        baseTile.AddWall(WallOrientation.right);
        baseTile.AddWall(WallOrientation.down);
        baseTile = AddTile(new Vector2(1, 1));
        baseTile.AddFloor();
        baseTile.AddWall(WallOrientation.right);
        baseTile.AddWall(WallOrientation.up);
    }

    public Tile AddTile(Vector2 pos)
    {
        var res = GetTile(pos);
        if (null != res) return res;
        res = new Tile($"{Name}'s Tile({pos.x}, {pos.y})", this);
        res.Physics.Position = pos;
        Tiles.Add(res);
        AddComp(res);
        return res;
    }

    public void RmTile(Vector2 pos)
    {
        var tile = GetTile(pos);
        if (tile == null) return;
        RmComp(tile);
        Tiles.Remove(tile);
    }

    public Tile GetTile(Vector2 pos)
    {
        foreach(var tile in Tiles)
        {
            if (tile.Physics.Position == pos) return tile;
        }
        return null;
    }

    public bool IsOpenSpace(Vector2 pos)
    {
        var tile = GetTile(pos);
        if (tile == null) return true;
        if (tile.Components.Count == 0) return true;
        return false;
    }
}
