using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public partial class Tile
{
    public void UpdateIsSpace()
    {
        IsSpace = Components.Count == 0;
        var ParentShip = (SpaceShip)Parent;
        if (IsSpace)
        {
            tileCheck(Physics.Position + new Vector2(0, 1));
            tileCheck(Physics.Position + new Vector2(0, -1));
            tileCheck(Physics.Position + new Vector2(1, 0));
            tileCheck(Physics.Position + new Vector2(1, 1));
            tileCheck(Physics.Position + new Vector2(1, -1));
            tileCheck(Physics.Position + new Vector2(-1, 0));
            tileCheck(Physics.Position + new Vector2(-1, 1));
            tileCheck(Physics.Position + new Vector2(-1, -1));
            CheckForDeath();
        }
        else
        {
            ParentShip.AddTile(Physics.Position + new Vector2(0, 1));
            ParentShip.AddTile(Physics.Position + new Vector2(0, -1));
            ParentShip.AddTile(Physics.Position + new Vector2(1, 0));
            ParentShip.AddTile(Physics.Position + new Vector2(1, 1));
            ParentShip.AddTile(Physics.Position + new Vector2(1, -1));
            ParentShip.AddTile(Physics.Position + new Vector2(-1, 0));
            ParentShip.AddTile(Physics.Position + new Vector2(-1, 1));
            ParentShip.AddTile(Physics.Position + new Vector2(-1, -1));
        }
    }
    void tileCheck(Vector2 pos)
    {
        var ParentShip = (SpaceShip)Parent;
        var tile = ParentShip.GetTile(pos);
        if (tile != null)
            tile.CheckForDeath();
    }
    public void CheckForDeath()
    {
        var IsBordering = false;
        var ParentShip = (SpaceShip)Parent;
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(0, 1));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(0, -1));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(1, 0));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(1, 1));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(1, -1));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(-1, 0));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(-1, 1));
        IsBordering |= !ParentShip.IsOpenSpace(Physics.Position + new Vector2(-1, -1));
        if (!IsBordering) die();
    }

}
