using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public partial class Tile
{
    public Wall up;
    public Wall down;
    public Wall left;
    public Wall right;
    public Wall crossLeft;
    public Wall crossRight;

    public void AddWall(WallOrientation wallorientation)
    {
        var wall = GetWall(wallorientation);
        if (wall != null) return;
        wall = GetNewWall(wallorientation);
        SetWall(wallorientation, wall);
        AddComp(wall);
        UpdateIsSpace();
    }

    public void AddExistingWall(Wall existing, WallOrientation wallorientation)
    {
        var wall = GetWall(wallorientation);
        if (wall != null) return;
        wall = existing;
        SetWall(wallorientation, wall);
        AddComp(wall);
        UpdateIsSpace();
    }

    public void RmWall(WallOrientation wallorientation)
    {
        var wall = GetWall(wallorientation);
        if (wall == null) return;
        Object.Destroy(wall.Instance);
        RmComp(wall);
        SetWall(wallorientation, null);
        UpdateIsSpace();
    }

    public Wall GetWall(WallOrientation wallorientation)
    {
        switch (wallorientation)
        {
            case WallOrientation.up:
                return up;
            case WallOrientation.down:
                return down;
            case WallOrientation.left:
                return left;
            case WallOrientation.right:
                return right;
            case WallOrientation.crossLeft:
                return crossLeft;
            case WallOrientation.crossRight:
                return crossRight;
        }
        return null;
    }
    public Wall GetNewWall(WallOrientation wallorientation)
    {
        var ParentShip = (SpaceShip)Parent;
        switch (wallorientation)
        {
            case WallOrientation.up:
                Wall wall;
                wall = new Wall(ParentShip, Name + $"'s {wallorientation} Wall");
                wall.Physics.Position = new Vector2(0, 0.5f);
                wall.Physics.transform.eulerAngles = new Vector3(0, 0, 90);
                return wall;
            case WallOrientation.down:
                wall = new Wall(ParentShip, Name + $"'s {wallorientation} Wall");
                wall.Physics.Position = new Vector2(0, -0.5f);
                wall.Physics.transform.eulerAngles = new Vector3(0, 0, 90);
                return wall;
            case WallOrientation.left:
                wall = new Wall(ParentShip, Name + $"'s {wallorientation} Wall");
                wall.Physics.Position = new Vector2(-0.5f, 0);
                return wall;
            case WallOrientation.right:
                wall = new Wall(ParentShip, Name + $"'s {wallorientation} Wall");
                wall.Physics.Position = new Vector2(0.5f, 0);
                return wall;
            case WallOrientation.crossLeft:
                wall = new Wall(ParentShip, Name + $"'s {wallorientation} Wall");
                wall.Physics.transform.eulerAngles = new Vector3(0, 0, 45);
                wall.Physics.transform.localScale = new Vector3(1, (float)System.Math.Sqrt(2), 0);
                wall.Physics.Mass = (float)System.Math.Sqrt(2);
                return wall;
            case WallOrientation.crossRight:
                wall = new Wall(ParentShip, Name + $"'s {wallorientation} Wall");
                wall.Physics.transform.eulerAngles = new Vector3(0, 0, -45);
                wall.Physics.transform.localScale = new Vector3(1, (float)System.Math.Sqrt(2), 1);
                wall.Physics.Mass = (float)System.Math.Sqrt(2);
                return wall;
        }
        return null;
    }
    public void SetWall(WallOrientation wallorientation, Wall val)
    {
        switch (wallorientation)
        {
            case WallOrientation.up:
                up = val;
                break;
            case WallOrientation.down:
                down = val;
                break;
            case WallOrientation.left:
                left = val;
                break;
            case WallOrientation.right:
                right = val;
                break;
            case WallOrientation.crossLeft:
                crossLeft = val;
                break;
            case WallOrientation.crossRight:
                crossRight = val;
                break;
        }
    }
}

public enum WallOrientation
{
    up,
    down,
    left,
    right,
    crossLeft,
    crossRight
}
