using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Experimental.Rendering.Universal;
using UnityEngine.UI;

public class Wall : SpaceEntityComponent
{

    public SpaceEntityPhysics parent;
    SpriteRenderer spriteRenderer;
    GameObject Shadow;

    public Wall(SpaceShip ParentEnity, string name) : base(name, ParentEnity)
    {
        Shadow = new GameObject("ShadowCaster");
        var shadow = Shadow.AddComponent<ShadowCaster2D>();
        shadow.transform.parent = Instance.transform;
        shadow.transform.localScale = new Vector3(0.25f, 1, 1);
        spriteRenderer = Instance.AddComponent<SpriteRenderer>();
        spriteRenderer.sprite = WallSkin.Basic;
        parent = ParentEnity.Physics;
        Physics.Mass = 392.5f;
        InitPhysics();
        Exists = true;
        
    }

    protected override void Collieded(Collision2D collision)
    {
        if (collision.gameObject.name == "Player")
        {
            var phys = collision.gameObject.GetComponent<SpaceEntityPhysics>();
        }
    }
}
