# get most accurate estimate of runtime by taking time at the beginning of file before imports (imports account for at least 2s of run-time)
from datetime import datetime
StartTime = datetime.now()
# 9:30 to make sure that it does not go overtime and that we have time to wrap up (close file and exit program with success)
MAX_RUNTIME = 9 * 60 + 30

# standard library imports
import time

# utility for logging
from PiLogger import *

# utility functions
def calculate_speed_in_kmps(feature_distance, gsd, time_difference):
    distance = feature_distance * gsd / 100000
    speed = distance / time_difference
    return speed

def get_runtime():
    now = datetime.now()
    time_diff = now - StartTime
    return time_diff.total_seconds()

# geometric mean is more precise because it ignores outliers more
def get_geometric_mean(res):
    total = 1

    for val in res:
        total *= val

    total = total ** (1/len(res))
    return  total

def main():

    """
    # experiments to find the best settings for calc_weighted_mean_feat_dist settings using custom downloaded images from previous astro-pi projects(cannot use Astro-Pi-Replay because of different resolution and thus GSD)

    t1 = ImageM.get_time("C:\\Users\GRaba\Downloads\\53238778733_446651a689_o.jpg")
    t2 = ImageM.get_time("C:\\Users\GRaba\Downloads\\53238778773_4231b1fc43_o.jpg")

    im1 = ImageM.read("C:\\Users\GRaba\Downloads\\53238778733_446651a689_o.jpg")
    im2 = ImageM.read("C:\\Users\GRaba\Downloads\\53238778773_4231b1fc43_o.jpg")

    feat_dist = ImageM.calc_weighted_mean_feat_dist(im2, im1, ErrorType.RMSE, True, False)
    time_diff = (t1 - t2).total_seconds()
    speed = calculate_speed_in_kmps(feat_dist, 12648, time_diff)
    print(speed)
    return
    """

    piLogger.info("Creating result.txt!")
    res_file = open("result.txt", "w", buffering=1)

    piLogger.info("Taking first image!")
    old_image, old_time = ImageM.capture()

    piLogger.operation_start("Repeated Speed Calculations")
    results = []

    while get_runtime() < MAX_RUNTIME:
        time.sleep(5) # produces a sample size of around 100
        new_image, new_time = ImageM.capture()

        # get new speed
        feat_dist = ImageM.calc_weighted_mean_feat_dist(old_image, new_image, ErrorType.RMSE, True, False)
        time_diff = (new_time - old_time).total_seconds()
        speed = calculate_speed_in_kmps(feat_dist, 12648, time_diff)
        results.append(speed)

        # write to result.txt
        mean_speed = get_geometric_mean(results)
        mean_speed = str(round(mean_speed, 4))
        piLogger.info(f"Found speed: {speed}, (geometric mean {mean_speed})")
        res_file.seek(0)
        res_file.write(mean_speed)

        # rotate images
        old_image = new_image
        old_time = new_time

    res_file.close()
    piLogger.operation_end()

    pass

# entry point here!
if __name__ == "__main__":

    piLogger = PiLogger()

    try:
        # Import in try catch in case of unavailability.
        import cv2
        from ImageManager import *

        ImageM = ImageManager(piLogger)
        piLogger.info("Starting Mission Space Lab ISS velocity calculations!")
        main()

    except Exception as e:
        piLogger.critical("Fatal Error! The exception was the following:")
        piLogger.error(e)
        piLogger.critical("Aborting! (exit code 2) //means error")

    piLogger.info("Success! Returning from program!")
    raise SystemExit(0)