import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation

# Set up the figure and axis
fig, ax = plt.subplots()

# Initial data (can be empty or a starting point)
agent_count = 100000
agents = [1 for i in range(agent_count)]
data = agents  # Example: 1000 random numbers
bins = np.linspace(1, 100, 99)  # Define bins for the histogram

# Create the initial histogram and capture the bars (patches)
n, bins, patches = ax.hist(data, bins=bins, color='skyblue', edgecolor='black')
ax.set_title("Free Market Capitalism")
ax.set_xlabel("Value")
ax.set_ylabel("Frequency")


import random

# Function to generate a new "frame" of data
def generate_frame():
    global  agents
    random.shuffle(agents)
    half = round(agent_count/2) - 1
    first_agent = agents[:half]
    second_agent = agents[half:]

    for i, pair in enumerate(zip(first_agent, second_agent)):
        if 0 in pair:
            continue
        num = random.randint(0, 1)
        if num == 0:
            first_agent[i] -= 1
            second_agent[i] += 1
        else:
            first_agent[i] -= 1
            second_agent[i] += 1

    first_agent.extend(second_agent)
    agents = first_agent

    # Replace this with your own data generation logic
    return agents # New random data for each frame


# Animation update function
def update(frame):
    # Generate new data for this frame
    new_data = generate_frame()

    # Compute the new histogram counts
    n, _ = np.histogram(new_data, bins=bins)

    # Update the height of each bar in the histogram
    for count, bar in zip(n, patches):
        bar.set_height(count)

    # Adjust the y-axis limit dynamically if needed
    ax.set_ylim(0, max(n) * 1.1)  # Add some padding above max height

    return patches


# Create the animation
ani = FuncAnimation(fig, update, frames=50000, interval=1, blit=True)
# - frames: number of frames (or can be an iterator)
# - interval: delay between frames in milliseconds
# - blit=True: optimize by only redrawing changed elements

# Display the animation
plt.show()