gold_file = open("gold.csv", "r")
lines = gold_file.readlines()
gold_file.close()

first_line= 0
for i, line in enumerate(lines):
    if "1900-01" in line:
        first_line = i
        break

lines = lines[first_line:]
data = [line.split(",")[1] for line in lines]
data = [float(val) for val in data]

variance = []

for i, val in enumerate(data[:-1]):
    variance.append(data[i + 1] - val)

samples = 10000

import random

res = []
for i in range(samples):
    idx = random.randint(0, len(data) - 1)
    start = data[idx]
    res_val = start
    for i in range(6):
        change = random.choice(variance)
        res_val += change
    res.append(res_val - start)

res = sorted(res)
values = res[:round(samples * 0.05)]
summed = 0
for vals in values:
    summed += vals
print(summed)

import matplotlib.pyplot as pl

pl.hist(res, bins=75)
pl.show()

