import math
start_date = "1971 Q1"
end_date = "1971 FEB"

labour_file = open("labour.csv", "r")
labour_data = labour_file.readlines()
labour_file.close()

first_line = 0
for i, line in enumerate(labour_data):
    if start_date in line:
        first_line = i
        break

last_line = 0
for i, line in enumerate(labour_data):
    if end_date in line:
        last_line = i
        break

labour_data = labour_data[first_line:last_line]
labour_data = [line.split(",")[1] for line in labour_data]
labour_data = [number.replace("\"", "") for number in labour_data]
labour_data = [int(number) * 1000 for number in labour_data]

employment_file = open("employment.csv", "r")
employment_data = employment_file.readlines()
employment_file.close()

first_line = 0
for i, line in enumerate(employment_data):
    if start_date in line:
        first_line = i
        break

last_line = 0
for i, line in enumerate(employment_data):
    if end_date in line:
        last_line = i
        break

employment_data = employment_data[first_line:last_line]
employment_data = [line.split(",")[1] for line in employment_data]
employment_data = [number.replace("\"", "") for number in employment_data]
employment_data = [float(number) / 100 for number in employment_data]

labour = []
for l, e in zip(labour_data, employment_data):
    res = round(l * e)
    labour.append(res)


gdp_file = open("gdp.csv", "r")
gdp_data = gdp_file.readlines()
gdp_file.close()

first_line = 0
for i, line in enumerate(gdp_data):
    if start_date in line:
        first_line = i
        break

gdp_data = gdp_data[first_line:]
gdp_data = [line.split(",")[1] for line in gdp_data]
gdp_data = [number.replace("\"", "") for number in gdp_data]
gdp_data = [float(number) * 1000_000 for number in gdp_data]


from decimal import Decimal

alpha = 0.25
k_0 = gdp_data[0] * 240000
a_0 = 470
g = 0.0073
d = 0.002
s = 0.11
y_0 = gdp_data[0] + 2.5e11

def a(t):
    return a_0 * math.exp(t * g)

def k(prev_y, prev_k):
    return prev_k + float(Decimal(prev_y) * Decimal(s) - Decimal(prev_k) * Decimal(d))

def y(lab, prev_y, prev_k, t):
    new_k = k(prev_y, prev_k)
    return new_k , (new_k ** alpha) * ((a(t) * lab)**(1 - alpha))

current_k = k_0
current_y = y_0

out = [y_0]

for month, l in enumerate(labour):
    current_k, res = y(l, current_y, current_k, month)
    current_y = res
    out.append(res)

out = out[:-1]
out = [val - 2.5e11 for val in out]

import matplotlib.pyplot as plt
from datetime import datetime
import pandas as pd

# Generate quarter labels from 1971 Q1 to 2024 Q3
quarters = []
start_year = 1971
end_year = 2024

for year in range(start_year, end_year + 1):
    for q in range(1, 5):  # Q1 to Q4
        if year == 2024 and q > 3:  # Stop at Q3 2024
            break
        quarters.append(f"{year} Q{q}")

# Create a simple plot with quarters on x-axis
plt.figure(figsize=(12, 6))
x_values = range(len(quarters))
plt.plot(x_values, gdp_data, color='r', label='Real GDP')
plt.plot(x_values, out, color='b', label='Best fitting GDP')

# Set x-axis ticks and labels
plt.xticks(x_values, quarters, rotation=45, ha='right')

# Adjust layout to prevent label cutoff
plt.tight_layout()

step = 4
plt.xticks(x_values[::step], quarters[::step], rotation=45, ha='right')

plt.xlabel('Quarters')
plt.ylabel('Values')
plt.title('GDP Data by Quarter (1971 Q1 - 2024 Q3)')
plt.show()